/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NAlias;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NQname;
import org.python.indexer.ast.NUrl;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NImport
extends NNode {
    static final long serialVersionUID = -2180402676651342012L;
    public List<NAlias> aliases;

    public NImport(List<NAlias> list) {
        this(list, 0, 1);
    }

    public NImport(List<NAlias> list, int n, int n2) {
        super(n, n2);
        this.aliases = list;
        this.addChildren(list);
    }

    @Override
    public boolean bindsName() {
        return true;
    }

    @Override
    protected void bindNames(Scope scope) throws Exception {
        NImport.bindAliases(scope, this.aliases);
    }

    static void bindAliases(Scope scope, List<NAlias> list) throws Exception {
        NameBinder nameBinder = NameBinder.make();
        for (NAlias nAlias : list) {
            if (nAlias.aname == null) continue;
            nameBinder.bind(scope, nAlias.aname, (NType)new NUnknownType());
        }
    }

    @Override
    public NType resolve(Scope scope) throws Exception {
        Scope scope2 = scope.getScopeSymtab();
        for (NAlias nAlias : this.aliases) {
            NType nType = NImport.resolveExpr(nAlias, scope);
            if (!nType.isModuleType()) continue;
            this.importName(scope2, nAlias, nType.asModuleType());
        }
        return this.getType();
    }

    private void importName(Scope scope, NAlias nAlias, NModuleType nModuleType) throws Exception {
        if (nAlias.aname != null) {
            if (nModuleType.getFile() != null) {
                NameBinder.make().bind(scope, nAlias.aname, (NType)nModuleType);
            } else {
                scope.update(nAlias.aname.id, new NUrl("http://docs.python.org/library/" + nModuleType.getTable().getPath() + ".html"), (NType)nModuleType, NBinding.Kind.SCOPE);
            }
        }
        NImport.addReferences(scope, nAlias.qname, true);
    }

    static void addReferences(Scope scope, NQname nQname, boolean bl) {
        if (nQname == null) {
            return;
        }
        if (!nQname.getType().isModuleType()) {
            return;
        }
        NModuleType nModuleType = nQname.getType().asModuleType();
        String string = nModuleType.getTable().getPath();
        NBinding nBinding = Indexer.idx.lookupQname(string);
        if (nBinding == null) {
            nBinding = Indexer.idx.moduleTable.lookup(string);
        }
        if (nBinding == null) {
            Indexer.idx.putProblem(nQname.getName(), "module not found");
            return;
        }
        Indexer.idx.putLocation(nQname.getName(), nBinding);
        if (bl && nQname.isTop()) {
            scope.put(nQname.getName().id, nBinding);
        }
        NImport.addReferences(scope, nQname.getNext(), false);
    }

    public String toString() {
        return "<Import:" + this.aliases + ">";
    }

    @Override
    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNodeList(this.aliases, nNodeVisitor);
        }
    }
}

